<?php

/**
 * LoginForm class.
 * LoginForm is the data structure for keeping
 * user login form data. It is used by the 'login' action of 'SiteController'.
 */
class Form1 extends DocumentFormModel
{
	//1st page
	public $name_surname;
	public $address;
	public $telephone_number;
	public $id_series;
	public $id_number;
	public $issuing_authority;
	public $PESEL;
	public $NIP;
	public $education;
	public $experience;
	public $other_skills;
	public $material_status;
	public $birth_date;
	public $spouses_business;
	public $past_buissness;
	public $employment_status;

	//2nd page
	public $funding_amount;
	public $company_type;
	public $PKD;
	public $company_address;
	public $office_form;
	public $actions_taken;
	public $project_characteristic;
	public $securing_reimbursement;

	//5th page
	public $costs_type;
	public $costs_unit;

	//6th page
	public $substantiation;

	//7th page
	public $planed_sales_monthly;
	public $planed_sales_annually;

	private $_identity;

	public function Form1()
	{
		$insertValues = "";
		$formId = get_class($this);

		foreach($this->attributes as $name=>$attribute)
		{
			$insertValues.= '\''.$formId.'_'.$name.'\' as nazwa UNION SELECT ';
		}
		if(!empty($insertValues))
			$insertValues = substr_replace($insertValues ,"",-14);

		$sql = "INSERT OR IGNORE INTO FormularzPole (nazwa) SELECT ".$insertValues."";
		Yii::app()->db->createCommand($sql)->execute();

		$this->find($formId);
	}

	/**
	 * Declares the validation rules.
	 * The rules state that username and password are required,
	 * and password needs to be authenticated.
	 */
	public function rules()
	{
		return array(
			array('name_surname', 'required'),
			array('address,telephone_number,id_series,id_number,issuing_authority,PESEL,
				NIP,education,experience,other_skills,material_status,birth_date,
				spouses_business,past_buissness,employment_status','safe'),
			array('NIP', 'ext.Validators.IdentityNumberValidator', 'disableChecksum' => true),
			array('PESEL', 'ext.Validators.PeselValidator', 'disableChecksum' => true)
		);
	}

	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
		);
	}

}
